<?php
/**
 * Plugin Name: Webforia Raja Ongkir Save Destination
 * Plugin URI:  https://webforia.com
 * Description: Save RajaOngkir Select2 AJAX field (cart_destination_label) into WooCommerce Billing Address 2.
 * Version:     1.0.0
 * Author:      Webforia
 * Author URI:  https://webforia.com
 * License:     GPLv2 or later
 * Text Domain: webforia-ro-save-destination
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * Save Select2 AJAX field (cart_destination_label)
 * into Billing Address 2
 */
add_action( 'woocommerce_checkout_create_order', 'webforia_save_select2_destination_to_address2', 20, 2 );

function webforia_save_select2_destination_to_address2( $order, $data ) {

    if ( isset( $_POST['cart_destination_label'] ) ) {

        $value = sanitize_text_field( $_POST['cart_destination_label'] );

        if ( ! empty( $value ) ) {

            // Save to billing address 2
            $order->set_billing_address_2( $value );

            // Backup custom meta (optional but recommended)
            $order->update_meta_data( 'cart_destination_label', $value );
        }
    }
}

add_filter( 'woocommerce_order_formatted_shipping_address', 'webforia_add_destination_to_shipping_address', 20, 2 );

function webforia_add_destination_to_shipping_address( $address, $order ) {

    $destination = $order->get_billing_address_2();

    if ( ! empty( $destination ) ) {
        $address['address_2'] = $destination;
    }

    return $address;
}